<?php
class SubscriptionsAdmin
{
  private $dbo = null;
  
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  
  function showList()
  {
    if(!$this->dbo){
      echo 'Lista subskrypcji nie jest dostępna.';
      return;
    }
    
    //Formowanie zapytania pobierającego listę subskrypcji
    $query = "SELECT COUNT(su.UserId), s.Id, s.Nazwa "
           . "FROM Subskrypcje s LEFT JOIN Subskrypcje_Uzytkownicy su "
           . "ON su.SubskrypcjaId = s.Id "
           . "GROUP BY s.Id";
    
    //Wykonanie zapytania
    if(!$subs = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Dołączenie szablonu
    include 'templates/subscriptionsList.php';
    return ACTION_OK;
  }

  function getEmailsList()
  {
    if(!$this->dbo){
      return SERVER_ERROR;
    }
    
    //Ustalenie separatora
    if(isset($_GET['separator'])){
      $separator = $_GET['separator'];
      $separator = str_replace(
          array('\n', '\r', '\t'),
          array("\n", "\r", "\t"),
          $separator
          );
    }
    else{
      $separator = ",\n";
    }
    
    //Pobranie wszystkich identyfikatorów z tabeli Subskrypcje
    $query = "SELECT Id FROM Subskrypcje";
    
    if(!$result = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Utworzenie ciągu identyfikatorów subskrypcji zaznaczonych w formularzu
    $str = '0';
    while($row = $result->fetch_row()){
      if(isset($_GET[$row[0]])){
        $str .= ','.$row[0];
      }
    }
    
    //Formowanie zapytania pobierającego adresy e-mail
    $query = 'SELECT DISTINCT email FROM Users u '
           . 'INNER JOIN Subskrypcje_Uzytkownicy su '
           . 'ON u.Id = su.UserId '
           . 'WHERE su.SubskrypcjaId IN ('.$str.') ';
    
    if(!$result = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Ustawienie licznika wierszy
    $rowsNo = $result->num_rows;
    $count = 0;
    
    //Wysłanie wyników do przeglądarki
    header("Content-Type: text/plain");
    header("Content-Disposition: attachment; filename=subskrypcje.txt");
    
    while($row = $result->fetch_row()){
      echo $row[0];
      if(++$count < $rowsNo){
        echo $separator;
      }
    }
    return ACTION_OK;
  }
  
}
?>